<?php
global $wpdb;
$orders = $wpdb->get_results("SELECT * FROM courses_paid");
?>

<h2><?php _e( 'تاكيد التحويل وتفعيل اشتراك الدرس', 'a7md' ) ?></h2>


<?php if ($orders) : ?>
<table class="wp-list-table widefat fixed striped pages">
    <thead>
    <tr>
        <td><?php _e( 'اسم العميل', 'a7md' ) ?></td>
        <td><?php _e( 'إسم الدرس', 'a7md' ) ?></td>
        <td><?php _e( 'المبلغ المحول', 'a7md' ) ?></td>
        <td><?php _e( 'صورة التحويل', 'a7md' ) ?></td>
        <td><?php _e( 'عدد المشتركين', 'a7md' ) ?></td>
        <td><?php _e( 'تاريخ الاشتراك', 'a7md' ) ?></td>
        <td><?php _e( 'تفعيل', 'a7md' ) ?></td>
    </tr>
    </thead>
    <tbody id="the-list">
    <?php foreach ($orders as $order) : ?>
        <tr class="">
            <td>
                <?php the_author_meta('nickname', $order->userid); ?>
            </td>
            <td>
                <a href="<?php echo get_permalink($order->coursid) ?>">
                    <?php echo get_the_title($order->coursid); ?>
                </a>
            </td>

            <td>
                <?php echo $order->price_paid; ?><?php _e( ' ريال', 'a7md' ) ?>
            </td>
            <td>
                <a href="<?php echo home_url() . '/wp-content/'. $order->screen; ?>" target="_blank">
                    <img class="img-fluid" src="<?php echo home_url() . '/wp-content/'. $order->screen; ?>" style="    max-width: 40px;">
                </a>
            </td>

            <td>
                <?php
                global $wpdb;
                $regs = $wpdb->get_results("SELECT * FROM courses_paid WHERE  coursid= '" . $order->coursid . "'");
                echo count($regs);
                ?>
                <?php _e( ' مشترك', 'a7md' ) ?>

            </td>



            <td>
                <?php echo $order->created_at; ?>
            </td>

            <td>
                <label class="switch">
                    <input type="checkbox"
                           class="mycheck"
                           value="<?php echo $order->id; ?>"
                        <?php echo ($order->status == 'true' ? 'checked' : '');?> />
                    <span class="slider"></span>
                </label>
            </td>
        </tr>
    <?php endforeach; ?>
    </tbody>
    <?php endif; ?>
</table>



<script type="text/javascript">
    jQuery('.mycheck').change(function() {
        if(jQuery(this).is(':checked')){
            var status = 'true';
        }else{
            var status = 'false';
        }
        var courid = jQuery(this).val();
        jQuery.ajax( {
            type: 'POST',
            url: '<?php echo get_site_url()?>/wp-admin/admin-ajax.php',
            dataType: 'json',
            data: { 'action': 'myFunction', 'status' : status, 'courseid' : courid},

            success: function (data) {

            },
            error: function (data) {
                console.log(data);
            }

        } );
    });

</script>

<style>
    .switch {
        position: relative;
        display: inline-block;
        width: 60px;
        height: 34px;
    }

    .switch input {
        opacity: 0;
        width: 0;
        height: 0;
    }

    .slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #ccc;
        -webkit-transition: .4s;
        transition: .4s;
    }

    .slider:before {
        position: absolute;
        content: "";
        height: 26px;
        width: 26px;
        left: 4px;
        bottom: 4px;
        background-color: #fff;
        -webkit-transition: .4s;
        transition: .4s;
    }

    input:checked + .slider {
        background-color: #2196F3;
    }

    input:focus + .slider {
        box-shadow: 0 0 1px #2196F3;
    }

    input:checked + .slider:before {
        -webkit-transform: translateX(26px);
        -ms-transform: translateX(26px);
        transform: translateX(26px);
    }
</style>
